/*
 * Copyright 1993-2010 NVIDIA Corporation.  All rights reserved.
 *
 * NVIDIA Corporation and its licensors retain all intellectual property and 
 * proprietary rights in and to this software and related documentation. 
 * Any use, reproduction, disclosure, or distribution of this software 
 * and related documentation without an express license agreement from
 * NVIDIA Corporation is strictly prohibited.
 *
 * Please refer to the applicable NVIDIA end user license agreement (EULA) 
 * associated with this source code for terms and conditions that govern 
 * your use of this NVIDIA software.
 * 
 */


#include "../common/book.h"

int main( void ) {
    cudaDeviceProp  prop;

    int count;
    HANDLE_ERROR( cudaGetDeviceCount( &count ) );
    for (int i=0; i< count; i++) {
        HANDLE_ERROR( cudaGetDeviceProperties( &prop, i ) );
        printf( "   --- General Information for device %d ---\n", i );
        printf( "Nazwa:  %s\n", prop.name );
        printf( "Potencja obliczeniowy:  %d.%d\n", prop.major, prop.minor );
        printf( "Zegar:  %d\n", prop.clockRate );
        printf( "Warto deviceOverlap:  " );
        if (prop.deviceOverlap)
            printf( "Wczone\n" );
        else
            printf( "Wyczone\n");
        printf( "Limit czasu dziaania jdra:  " );
        if (prop.kernelExecTimeoutEnabled)
            printf( "Wczony\n" );
        else
            printf( "Wyczony\n" );

        printf( "   --- Informacje o pamici urzdzenia %d ---\n", i );
        printf( "Ilo pamici globalnej:  %ld\n", prop.totalGlobalMem );
        printf( "Ilo pamici staej:  %ld\n", prop.totalConstMem );
        printf( "Maks. szeroko pamici:  %ld\n", prop.memPitch );
        printf( "Wyrwnanie tekstur:  %ld\n", prop.textureAlignment );
        printf( "   --- Informacje na temat wieloprocesorw urzdzenia %d ---\n", i );
        printf( "Liczba wieloprocesorw:  %d\n",
                    prop.multiProcessorCount );
        printf( "Pami wsplna na wieloprocesor:  %ld\n", prop.sharedMemPerBlock );
        printf( "Rejestry na wieloprocesor:  %d\n", prop.regsPerBlock );
        printf( "Liczba wtkw w osnowie:  %d\n", prop.warpSize );
        printf( "Maks. liczba wtkw na blok:  %d\n",
                    prop.maxThreadsPerBlock );
        printf( "Maks. liczba wymiarw wtkw:  (%d, %d, %d)\n",
                    prop.maxThreadsDim[0], prop.maxThreadsDim[1],
                    prop.maxThreadsDim[2] );
        printf( "Maks. liczba wymiarw siatki:  (%d, %d, %d)\n",
                    prop.maxGridSize[0], prop.maxGridSize[1],
                    prop.maxGridSize[2] );
        printf( "\n" );
    }
}
